function plot_Isurf_2

%Plots the current, voltage, insolation characteristics of a BP385 PV string 
%Ambient temperature = 25C
%Loads the current surface called Isurf_BP365. 
%Inputs are voltage and insolation.
%Format of lookup data is (Sun:voltage:temperature)
%Temperature values are defined as 1: 0C, 2: 25C, 3: 50C

load('Isurf_BP365.mat'); 
n = 1; %number of panels in array
voltage = [0:0.05:25].*n;
Sun = 0:0.1:1;
I1 = Isurf_BP365(:,11,2)    %Sun = 1.0, i.e. 1 kW/m2
I2 = Isurf_BP365(:,6,2);    %0.5 kW/m2

%Plot the current surface
figure(1)
clf
surf(Sun, voltage, Isurf_BP365(:,:,2)); %Current surface for 25C
view([-102 28]);
xlabel('Insolation (kWh/m2)', 'Fontsize', 12)
ylabel('Voltage (V)', 'Fontsize', 12)
zlabel('Current (A)', 'Fontsize', 12)
set(gca, 'FontSize', 12)

%Plot maximum nominal output characteristics
figure(2)
h = plot(voltage, I1, voltage, I2);
set(h, 'Linewidth', 2);
set(gca, 'FontSize', 14)
grid on
xlabel('Voltage (V)', 'Fontsize', 14)
ylabel('Current (A)', 'Fontsize', 14)
title('IV characteristic', 'Fontsize', 14);
legend('1 kW/m2', '0.5 kW/m2')

figure(3)
h = plot(voltage, voltage.*I1', voltage, voltage.*I2');
set(h, 'Linewidth', 2);
set(gca, 'FontSize', 14)
grid on;
xlabel('Voltage (V)', 'Fontsize', 14)
ylabel('Power (W)', 'Fontsize', 14)
title('PV characteristic', 'Fontsize', 14);
legend('1 kW/m2', '0.5 kW/m2')